#### 解题思路：

-  若 $n = 2^x$ 且 $x$ 为自然数（即 $n$ 为 $2$ 的幂），则一定满足以下条件：
    1. 恒有 `n & (n - 1) == 0`，这是因为： 
        - $n$ 二进制最高位为 $1$，其余所有位为 $0$；
        - $n - 1$ 二进制最高位为 $0$，其余所有位为 $1$；
    2. 一定满足 `n > 0`。
- 因此，通过 `n > 0` 且 `n & (n - 1) == 0` 即可判定是否满足 $n = 2^x$。

| 2^x   | n      | n - 1  | n & (n - 1)          |
| ----- | ------ | ------ | -------------------- |
| $2^0$ | $0001$ | $0000$ | (0001) & (0000) == 0 |
| $2^1$ | $0010$ | $0001$ | (0010) & (0001) == 0 |
| $2^2$ | $0100$ | $0011$ | (0100) & (0011) == 0 |
| $2^3$ | $1000$ | $0111$ | (1000) & (0111) == 0 |
| ...   | ...    | ...    | ...                  |

#### 代码：

```Python []
class Solution:
    def isPowerOfTwo(self, n: int) -> bool:
        return n > 0 and n & (n - 1) == 0
```

```Java []
class Solution {
    public boolean isPowerOfTwo(int n) {
        return n > 0 && (n & (n - 1)) == 0;
    }
}
```
